<?php

require 'vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\IOFactory;

function lirePremieresColonnes($fichierXlsx) {
    $spreadsheet = IOFactory::load($fichierXlsx);

    $feuilles = $spreadsheet->getAllSheets();

    $resultats = [];

    foreach ($feuilles as $feuille) {
        $nomFeuille = $feuille->getTitle();
        $premieresColonnes = [];

        $nombreLignes = $feuille->getHighestRow();

        for ($ligne = 2; $ligne <= $nombreLignes; $ligne++) {
            $premiereColonne = $feuille->getCell('A'.$ligne)->getValue();
            $premieresColonnes[] = $premiereColonne;
        }

        $resultats[$nomFeuille] = $premieresColonnes;
    }

    return $resultats;
}

$fichierXlsx = 'file.xlsx';
$donnees = lirePremieresColonnes($fichierXlsx);

// Convertir les données en format JSON
$jsonDonnees = json_encode($donnees, JSON_PRETTY_PRINT);

// Enregistrer les données JSON dans un fichier
$fichierJson = 'resultats.json';
file_put_contents($fichierJson, $jsonDonnees);

echo "Les données ont été enregistrées dans '$fichierJson'.";
?>
