$(document).ready(function () {
    const elements = [
        1650015435, 1650015436,1332201446, 1332201436, 1332201439,
        1332201447, 1332201443, 1332201435, 1332201442, 1332201445,
        1332203443, 1332203442, 1332203435, 1332203432, 1332203438,
        1303030436, 1700012435, 1303038435, 1303043437, 1303043445,
        1102022431, 1102022445, 1102012438, 1102115438, 1102120442,
        1650010435, 1102514435, 1302001431, 1302003432, 1102012431,
        1102012445
    ];

    const batchSize = 5;
    let progress = 0;

    function fetchBatch(startIndex) {
        const batch = elements.slice(startIndex, startIndex + batchSize);

        if (batch.length === 0) return;
        var ids = batch.join(",");
        $.ajax({
            url: "api.php?ids="+ids,
            method: "GET",
            contentType: "application/json",
            dataType: "json",
            success: function (response) {
                console.log(response.data);

                const data = response.data || [];
                updateTable(data);
                progress += batch.length;
                updateProgress(progress, elements.length);

                fetchBatch(startIndex + batchSize);
            },
            error: function () {
                console.error("Error fetching data for batch starting at index:", startIndex);
                progress += batch.length;
                updateProgress(progress, elements.length);

                fetchBatch(startIndex + batchSize);
            }
        });
    }

    function updateProgress(current, total) {
        $("#progress").text(`Progress: ${current}/${total} finished`);
        const percentage = Math.round((current / total) * 100);
        $("#progress-bar").css("width", `${percentage}%`);
        $("#progress-text").text(`${percentage}%`);
    }

    function updateTable(data) {
        data.forEach(item => {
            const row = `
                <tr>
                    <td>${item.partDescription}</td>
                    <td>${item.stockCode}</td>
                    <td>${item.pricing.map(price => `${price.unitPrice} (min: ${price.quantityMinimum})`).join(", ")}</td>
                    <td>${item.freeStock}</td>
                </tr>
            `;
            $("#results").append(row);
        });
    }

    fetchBatch(0);
});
