<?php
include '../../TurboPartScraperService.php';
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Turbo Part Scraper</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body>

<div class="w-80 m-auto">    
    <form method="POST" action="" class="bg-white shadow-md rounded px-8 pt-6 pb-8 mb-4">
        <label for="ids">Entrez les IDs des pièces (séparés par des virgules) :</label>
        <input class="mt-2 shadow appearance-none border rounded w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" type="text" id="ids" name="ids" placeholder="Ex: 1102012890,1700012800" required>
        <button  class="mt-2 shadow bg-purple-500 hover:bg-purple-400 focus:shadow-outline focus:outline-none text-white font-bold py-2 px-4 rounded"  type="submit">Lancer le scraping</button>
    </form>
</div>

<?php

if (isset($_GET['ids']) && !empty($_GET['ids'])) {
    $ids = explode(",", $_GET['ids']);
    if (is_array($ids) && count($ids) > 0) {
        $scraper = new TurboPartScraperService(
            $ids,                 // Liste des IDs des pièces
            true,                 // Sauvegarde les données pour chaque ID dans des fichiers uniques
            "RN0045E",            // Nom d'utilisateur
            "iVBo0tR0",           // Mot de passe
            "saves"               // Répertoire où les fichiers JSON seront sauvegardés
        );
    }
}

if (isset($_POST['ids']) && !empty($_POST['ids'])) {
    $ids = explode(",", $_POST['ids']);
    if (is_array($ids) && count($ids) > 0) {
        $scraper = new TurboPartScraperService(
            $ids,                 // Liste des IDs des pièces
            true,                 // Sauvegarde les données pour chaque ID dans des fichiers uniques
            "RN0045E",            // Nom d'utilisateur
            "iVBo0tR0",           // Mot de passe
            "saves"               // Répertoire où les fichiers JSON seront sauvegardés
        );
    }
}

if (isset($scraper)) {
    echo '<div class="message">';
    if (empty($scraper->jsonContent['errors'])) {
        echo '<p>Le scraping a réussi et les données ont été sauvegardées.</p>';
    }
    echo '</div>';
}
?>

</body>
</html>
