<?php
function setMessage($type,$entete,$message) {
    ?>
    <div class="sufee-alert alert with-close alert-<?php echo $type;?> alert-dismissible fade show">
        <span class="badge badge-pill badge-<?php echo $type;?>"><?php echo $entete;?></span>
        <?php echo $message;?>
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
    <?php
}

function createInputText($attr,$label,$resultat="") {
?>
    <div class="form-group">
        <label for="<?php echo $attr;?>" class="col-md-3 control-label"><?php echo $label;?></label>
        <div class="col-md-9">
            <input type="text" id="<?php echo $attr;?>" name="<?php echo $attr;?>" value="<?php echo $resultat;?>" class="form-control">
        </div>
    </div>
<?php
}

function createInputTextTooltip($attr,$label,$tooltip,$resultat="") {
?>
    <div class="form-group">
        <label for="<?php echo $attr;?>" class="col-md-3 control-label"><?php echo $label;?></label>
        <div class="col-md-9">
            <input type="text" id="<?php echo $attr;?>" name="<?php echo $attr;?>" value="<?php echo $resultat;?>" class="form-control" data-toggle="tooltip" data-trigger="hover" class="form-control" data-original-title="<?php echo $tooltip;?>">
        </div>
    </div>
<?php
}

function createInputPassword($attr,$label) {
?>
    <div class="form-group">
        <label for="<?php echo $attr;?>" class="col-md-3 control-label"><?php echo $label;?></label>
        <div class="col-md-9">
            <input type="password" id="<?php echo $attr;?>" name="<?php echo $attr;?>" class="form-control" data-original-title="Configuration du mdp:">
        </div>
    </div>
<?php
}


function createInputPasswordTooltip($attr,$label) {
?>
    <div class="form-group">
        <label for="<?php echo $attr;?>" class="col-md-3 control-label"><?php echo $label;?></label>
        <div class="col-md-9">
            <input type="password" id="<?php echo $attr;?>" name="<?php echo $attr;?>" data-toggle="tooltip" data-trigger="hover" class="form-control" data-original-title="Configuration du mdp:">
        </div>
    </div>
<?php
}

function createInputTextArea($attr,$label,$resultat="") {
?>
    <div class="form-group">
        <label class="col-md-3 control-label" for="<?php echo $attr;?>"><?php echo $label;?></label>
        <div class="col-md-9">
            <textarea class="form-control" rows="6" id="<?php echo $attr;?>" name="<?php echo $attr;?>"><?php echo $resultat;?></textarea>
        </div>
    </div>
    
<?php
}

function createInputWYSIWYG($attr,$label,$resultat="")
{
    ?>
    <script type="text/javascript" src="ckeditor/ckeditor.js"></script>
    <div class="form-group">
        <label class="col-md-3 control-label"><?php echo $label;?></label>
        <div class="col-md-9">
            <textarea class="form-control" rows="6" id="<?php echo $attr;?>" name="<?php echo $attr;?>"><?php echo $resultat;?></textarea>
            <script type="text/javascript">
            //<![CDATA[
                var editor = CKEDITOR.replace( "<?php echo $attr;?>" );
            //]]>
            </script>
        </div>
    </div>
    <?php
}

function createInputDateFormat($attr,$label,$resultat="") {
    if ($resultat!='')        $resultat=setDateFormat($resultat,'d/m/Y');
?>
    <div class="form-group">
        <label class="col-md-3 control-label"><?php echo $label;?></label>
        <div class="col-md-9">
            <div class="input-group">
                <span class="input-group-addon">
                    <i class="fa fa-calendar"></i>
                </span>
                <input id="<?php echo $attr;?>" name="<?php echo $attr;?>" data-plugin-masked-input data-input-mask="99/99/9999" placeholder="__/__/____" class="form-control" value="<?php echo $resultat;?>">
            </div>
        </div>
    </div>
<?php
}

function createInputDate($attr,$label,$resultat="") {
    if ($resultat!='')        $resultat=setDateFormat($resultat,'d/m/Y');
?>
    <div class="form-group">
        <label class="col-md-3 control-label"><?php echo $label;?></label>
        <div class="col-md-9">
            <div class="input-group">
                <span class="input-group-addon">
                    <i class="fa fa-calendar"></i>
                </span>
                <input type="text" data-plugin-datepicker class="form-control" name="<?php echo $attr;?>">
            </div>
        </div>
    </div>
<?php
}

function createInputNumber($attr,$label,$resultat="") {
?>
    <div class="form-group">
        <label for="<?php echo $attr;?>" class="col-md-3 control-label"><?php echo $label;?></label>
        <div class="col-md-9">
            <input type="text" id="<?php echo $attr;?>" name="<?php echo $attr;?>" value="<?php echo $resultat;?>" class="form-control">
        </div>
    </div>   
    <link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
    <script src="https://code.jquery.com/jquery-1.12.4.js"></script>
    <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>

    <script>
    $( function() {
        var spinner = $( "#<?php echo $attr;?>" ).spinner();
    } );
    </script>
<?php
}


function createInputRadio($attr,$tab,$label,$resultat="") {
?>
    <div class="form-group">
        <label class="col-sm-3 control-label"><?php echo $label;?></label>

        <div class="col-sm-9">
            <?php
                $i=1;
                foreach ($tab as $key=>$val) {
                echo '<div class="radio-custom"><input type="radio" id="'.$attr.$i.'" name="'.$attr.'" value="'.$key.'"';
                if ($val == $resultat || $key == $resultat)  echo " checked";
                echo '><label for="'.$attr.$i.'">'.$val.'</label></div>';
                    $i++;
                }
            ?>
        </div>
    </div>
    
<?php
}

function createInputCheckbox($tab,$label,$intitule,$resultat="") {
    $tabRes=explode(',',$resultat);
?>
   <div class="form-group">
        <label class="col-sm-3 control-label"><?php echo $intitule;?></label>

        <div class="col-sm-9">
            <?php
                // echo $attr;
                $i=1;
                foreach ($tab as $cle=>$val) {
                    echo '<div class="checkbox-custom checkbox-default"><input type="checkbox" id="'.$cle.'" name="'.$label.$i.'" value="'.$val.'"';
                    foreach ($tabRes as $resultat) if ($val==$resultat)    echo " checked";
                    echo '><label for="'.$val.'">'.$val.'</label></div>';
                    $i++;
                }
            ?>
        </div>
    </div>
<?php
}

function createInputSelect($id,$nomtable,$attr,$label,$name,$resultat="") { //Fonction permettant d'afficher une liste déroulante: il faut passer en paramètres la variable de connexion à la base de données, l'id, le nom et l'attribut à afficher de la table ainsi que le libelle à afficher à côté de l'input
    global $idBase;
    $trouve=false;
    $attr2=$attr;
    if (preg_match("/ as /", $attr)) list($info,$attr2)=explode(" as ",$attr);
    $sql="SELECT DISTINCT $id,$attr FROM $nomtable ORDER BY $attr2";
?>
    <div class="form-group">
        <label class="col-md-3 control-label"><?php echo $label;?></label>
        <div class="col-md-9">
            <select data-plugin-selectTwo class="form-control populate" name="<?php echo $name;?>" id="<?php echo $name;?>">
                <option value="" disabled selected></option>
                    <?php
                    $req=$idBase->query($sql);
                    while ($res=$req->fetch(PDO::FETCH_OBJ))
                    {
                        echo '<option value="'.$res->$id.'"';
                        if ($res->$id == $resultat || $res->$attr2 == $resultat) {echo " selected";$trouve=true;}
                        echo ">".$res->$attr2."</option>";
                    }
                    ?>
            </select><?php if ($resultat!='' && !$trouve) echo $resultat;?>
        </div>
    </div>
<?php
}

function createInputSelect2Tables($attr,$table,$table2,$attribut2,$att_joint1,$att_joint2,$label,$name,$resultat="")
{
    global $idBase;
    $trouve=false;
    $sql="select distinct `$table`.$attr,`$table2`.$attribut2 as Libelle FROM `$table`,`$table2` where `$table`.$att_joint1=`$table2`.$att_joint2 order by `$table`.$attr";

?>
    <div class="form-group">
        <label class="col-md-3 control-label"><?php echo $label;?></label>
        <div class="col-md-9">
            <select data-plugin-selectTwo class="form-control populate" name="<?php echo $name;?>" id="<?php echo $name;?>">
                <option value="" disabled selected></option>
                    <?php
                    $req=$idBase->query($sql);
                    while ($res=$req->fetch(PDO::FETCH_OBJ))
                    {
                        echo '<option value="'.$res->$id.'"';
                        if ($res->$attr == $resultat) {echo " selected";$trouve=true;}
                        echo ">".$res->Libelle."</option>";
                    }
                    ?>
            </select><?php if ($resultat!='' && !$trouve) echo $resultat;?>
        </div>
    </div>

<?php
}

function createInputSelectMultiple($id,$nomtable,$attr,$label,$name,$liste=array()) { //Fonction permettant d'afficher une liste déroulante: il faut passer en paramètres la variable de connexion à la base de données, l'id, le nom et l'attribut à afficher de la table ainsi que le libelle à afficher à côté de l'input; $liste permet de récupérer la liste des valeurs qui doivent être pré-selectionnées
    global $idBase;
    $sql="SELECT DISTINCT $id,$attr FROM $nomtable ORDER BY $attr";
?>
    <div class="form-group">
        <label class="col-md-3 control-label"><?php echo $label;?></label>
        <div class="col-md-9">
            <select multiple data-plugin-selectTwo class="form-control populate" name="<?php echo $name;?>[]" id="<?php echo $name;?>">
                <option value="" disabled selected></option>
                    <?php
                    $req=$idBase->query($sql);
                    while ($res=$req->fetch(PDO::FETCH_OBJ))
                    {
                        echo '<option value="'.$res->$id.'"';
                        if (in_array($res->$id, $liste)) echo " selected";
                        echo ">".$res->$attr."</option>";
                    }
                    ?>
            </select>
        </div>
    </div>
<?php
}

// mise en place d'un filtre multiple a partir de 2 tables (la table en cours et la téble de reference)
function createInputSelectMultiple2Tables($attr,$table,$table2,$attribut2,$att_joint1,$att_joint2,$label,$name,$liste=array())
{
    global $idBase;
    $sql="select distinct `$table`.$attr,`$table2`.$attribut2 as Libelle FROM `$table`,`$table2` where `$table`.$att_joint1=`$table2`.$att_joint2 order by `$table`.$attr";
?>
    <div class="form-group">
        <label class="col-md-3 control-label"><?php echo $label;?></label>
        <div class="col-md-9">
            <select multiple data-plugin-selectTwo class="form-control" populate name="<?php echo $name;?>[]" id="<?php echo $name;?>">
                <option value="" disabled selected></option>
                    <?php
                    $req=$idBase->query($sql);
                    while ($res=$req->fetch(PDO::FETCH_OBJ))
                    {
                        echo '<option value="'.$res->$attr.'"';
                        if (in_array($res->$attr, $liste)) echo " selected";
                        echo ">".$res->Libelle."</option>";
                    }
                    ?>
            </select>
        </div>
    </div>
<?php
}

function createInputFile($attr,$label,$resultat="") {
    global $nom_table;
?>
    <div class="form-group">
        <label class="col-md-3 control-label"><?php echo $label;?></label>
        <div class="col-md-9">
            <div class="fileupload fileupload-new" data-provides="fileupload">
                <div class="input-append">
                    <div class="uneditable-input">
                        <i class="fa fa-file fileupload-exists"></i>
                        <span class="fileupload-preview"></span>
                    </div>
                    <span class="btn btn-default btn-file">
                        <span class="fileupload-exists">Change</span>
                        <span class="fileupload-new">Select file</span>
                        <input type="file" id="<?php echo $attr;?>" name="<?php echo $attr;?>" />
                    </span>
                    <a href="#" class="btn btn-default fileupload-exists" data-dismiss="fileupload">Supprimer</a>
<?php            
                    if ($resultat!='' && $resultat!='NA')  
                    {
                        echo '<a href="./uploads/'.$nom_table.'/'.$resultat.'" target="blank">Fichier</a>';
                        echo '<div class="checkbox-custom checkbox-default"><input type=checkbox name=del'.$attr.' id=del'.$attr.'><label for="del'.$attr.'">Supprimer le document</label></div>';
                    }
?>
                </div>
            </div>
        </div>
    </div>
    <!--  -->

    <!-- </div><br /> -->
<?php
}

function setInfos($bg,$texte,$titre) {
?>
    <div class="row">
        <div class="col-md-3"></div>
        <div class="col-md-6">
            <section class="panel panel-featured panel-featured-success">
                <header class="panel-heading">
                    <h2 class="panel-title">Statut des <?php echo $titre;?></h2>
                </header>
                <div class="panel-body">
                    <code><?php echo $texte;?></code>
                </div>
            </section>
        </div>
        <div class="col-md-3"></div>
    </div>
<?php
}

function add_file($attr_name,$nom_table)
{
    $name=preg_replace("/ /","_",$_FILES[$attr_name]['name']);
    if ($name!="")      $resultat = move_uploaded_file($_FILES[$attr_name]['tmp_name'],"./uploads/$nom_table/$name");
}

function get($attr,$mult=false)
{
    $val="";
    if (isset($_GET[$attr]) && !empty($_GET[$attr]))        $val=preg_replace("/\'/", "\'", $_GET[$attr]);
    elseif (isset($_GET[$attr]))                            $val=preg_replace("/\'/", "\'", $_GET[$attr]);
    elseif (isset($_POST[$attr]) && !empty($_POST[$attr]))  $val=$_POST[$attr];
    elseif (isset($_POST[$attr]))                           $val=$_POST[$attr];
    return                                                  $val;
}

function post($attr,$mult=false)
{
    $val="";
    if (isset($_POST[$attr]) && !empty($_POST[$attr]))  $val=$_POST[$attr];
    elseif (isset($_POST[$attr]))                       $val=$_POST[$attr];
    return                                              $val;
}

function recherche($idBase,$table,$cle,$infoUSR,$info_rech) //permet de renvoyer l'info recherchée($info_rech) lorsque la cle dans la base ($cle) correspond à l'info donnée par l'user ($infoUSR)
{ 
    $req=$idBase->query("SELECT * FROM $table WHERE $cle='".get($infoUSR)."'");
    $data = $req->fetch();
    return $data[$info_rech];
}

// permet de récupérer les options multiples d'un select lors d'un filtre
function get_multi_filtre($nomchamp,$Field="")
{
    global $conditions,$type;
    if ($Field=="") $Field=$nomchamp;
    $val="";
    if(isset($_GET[$Field]) && is_array($_GET[$Field]) && !empty($_GET[$Field])){
        $array = $_GET[$Field];
        foreach($array as $selectValue){
            $selectValue=preg_replace("/'/", "\'", $selectValue);
                $val.=",'".$selectValue."'";
        }
        $val=substr($val,1);
        if ($val != "")     $conditions.=" and $nomchamp in ($val)";
    }
}

// permet de récupérer l' option d'un select lors d'un filtre
function get_simple_filtre($nomchamp,$Field)
{
    global $conditions;
    if(isset($_GET[$Field]) && !is_array($_GET[$Field]) && !empty($_GET[$Field])){
        $conditions.=" and $nomchamp in ('".$_GET[$Field]."')";
    }
}

// permet de récupérer la valeur d'un champ input lors d'un filtre
function get_text_filtre($nomchamp,$table="")
{
    global $conditions;
    if (isset($_GET[$nomchamp]))    
    {
        ${$nomchamp}=$_GET[$nomchamp];      
        if (${$nomchamp}!="")   
        {
            if ($table=="") $conditions .= " and $nomchamp like '%".${$nomchamp}."%'";
            else            $conditions .= " and $table.$nomchamp like '%".${$nomchamp}."%'";
        }
    }
}

// permet de récupérer la valeur d'un champ input lors d'un filtre
function get_text_filtre_strict($nomchamp,$table="")
{
    global $conditions;
    if (isset($_GET[$nomchamp]))    
    {
        ${$nomchamp}=$_GET[$nomchamp];      
        if (${$nomchamp}!="")   
        {
            if ($table=="") $conditions .= " and $nomchamp = '".${$nomchamp}."'";
            else            $conditions .= " and $table.$nomchamp = '".${$nomchamp}."'";
        }
    }
}

// permet de récupérer la valeur d'un champ input lors d'un filtre
function get_date_filtre($nomchamp,$operande="=")
{
    global $conditions;
    if (isset($_GET[$nomchamp]))    
    {
        ${$nomchamp}=$_GET[$nomchamp];      
        if (${$nomchamp}!="")   $conditions .= " and $nomchamp $operande '".${$nomchamp}."'";
    }
}

function setDroits()
{
    global $type,$tabDroits2,$tabDroits4,$tabDroits3,$tabDroits5,$droits,$droitsAdmin;
    // si superadmin droits toujours à true
    if ($_SESSION["UserLevel"] == -1)       
    {   
        $droits=true;
        $droitsAdmin=true;
    }
    // si droits Consultation + Téléchargement
    if ($_SESSION["UserLevel"] == 1)        
        $droits=false;
    // si droits Dépôt limité à  "Ressources humaines" + "Communication - Externe"
    if ($_SESSION["UserLevel"] == 2 && in_array($type, $tabDroits2))        
        $droits=true;
    // si droits Dépôt "Prévention" uniquement
    if ($_SESSION["UserLevel"] == 3 && in_array($type, $tabDroits3))        
        $droits=true;
    // si droits Dépôt limité à "Expérimentation"  + "Ressources humaines - Stagiaires" + "Communication - Externe"
    if ($_SESSION["UserLevel"] == 4 && in_array($type, $tabDroits4))        
        $droits=true;
    // si droits Dépôt limité à "Matériel" + "Documentation AQ" + "Expérimentation - Cahiers de laboratoire" + "Ressources humaines - Stagiaires" + "Communication - Externe"   
    if ($_SESSION["UserLevel"] == 5 && in_array($type, $tabDroits5))        
        $droits=true;
    // si droits Dépôt limité à "Matériel" + "Documentation AQ" + "Expérimentation - Cahiers de laboratoire" + "Ressources humaines - Stagiaires" + "Communication - Externe + Expérimentation"
    if ($_SESSION["UserLevel"] == 6 && (in_array($type, $tabDroits4) || in_array($type, $tabDroits5)))     
        $droits=true;
}

function getInfoFromRef($nomChamp,$value)
{
    global $idBase,$array_corres;
    $field=$array_corres[$nomChamp]["field"];
    $field2=$field;
    if (preg_match("/ as /", $field)) list($info,$field2)=explode(" as ",$field);

    $table=$array_corres[$nomChamp]["table"];
    $code=$array_corres[$nomChamp]["code"];
    // if ($nomChamp == "_Code_nature_mesure") echo "SELECT DISTINCT $field FROM $table where $code='".addslashes($value)."'<br />";
    $req=$idBase->query("SELECT DISTINCT $field FROM $table where $code='".addslashes($value)."'");
    if ($req->rowCount()==1)
    {
        $res=$req->fetch();
        return $res[$field2];
    }
    return $value;

}
function setDateFormat($dateIN,$format)
{
    if (preg_match("/\//", $dateIN))
    {
        $tab=explode("/",$dateIN);
        $dateIN=$tab[2]."-".$tab[1]."-".$tab[0];
    }
    if ($dateIN!='0000-00-00')  return date_format(date_create($dateIN),$format);
    else return "";
}

function stripAccents($string){
    return strtr($string,'àáâãäçèéêëìíîïñòóôõöùúûüýÿÀÁÂÃÄÇÈÉÊËÌÍÎÏÑÒÓÔÕÖÙÚÛÜÝ',
'aaaaaceeeeiiiinooooouuuuyyAAAAACEEEEIIIINOOOOOUUUUY');
}
?>
