<?php
class Commande {
    // attributs
    private $prixAmericain;
    private $prixBuffalo;
    private $nomClient;
    private $listeKebabs=array("Americain"=>0,"Buffalo"=>0);

    // constructeur
    public function __construct($prixBuffalo,$prixAmericain,$nomClient)
    {
        $this->prixBuffalo = $prixBuffalo;
        $this->prixAmericain = $prixAmericain;
        $this->nomClient = $nomClient;
    }

    // ajout de kebab
	public function addKebab($nomKebab,$nombre) 
	{
        $this->listeKebabs[$nomKebab] += $nombre;
		echo "Vous avez ajouté $nombre Kebab(s) $nomKebab<br >";
	}
	
    // suppression de kebab
 	public function removeKebab($nomKebab,$nombre) 
	{
        $this->listeKebabs[$nomKebab] -= $nombre;
		if ($this->listeKebabs[$nomKebab]<0) $this->listeKebabs[$nomKebab]=0;
		echo "Vous avez enlevé $nombre Kebab(s) $nomKebab<br >";
	}

    // calcul de prix: cette méthode est privée car elle est uniquement utilisée à l'intérieur de la classe
    private function calculerPrix() 
	{
        // méthode simple, on fait la somme pour chaque kebab
        $montant_Americain = $this->listeKebabs["Americain"] * $this->prixAmericain;
        $montant_Buffalo = $this->listeKebabs["Buffalo"] * $this->prixBuffalo;
        return $montant_Americain + $montant_Buffalo;
        
        // méthode générique, on crée une variable dynamique
        $montant=0;
        foreach ($this->listeKebabs as $key=>$val)
        {
        	$prix="prix".$key;
        	$montant+=$val*$this->$prix;
        }
        return $montant;
    }

    // affichage de la commande
    public function afficherCommande() 
	{
        echo "Commande du client : ".$this->nomClient."<ul>";
        echo "<li>".$this->listeKebabs["Americain"]." Kebab(s) Americain</li>";
        echo "<li>".$this->listeKebabs["Buffalo"]." Kebab(s) Buffalo</li></ul>";
        echo "<hr>Total de votre commande : ".$this->calculerPrix()." Euros<br />";    
	}

    // getters et setters
    public function getNomClient()
    {
        return $this->nomClient;
    }

    public function setNomClient($nomClient)
    {
        $this->nomClient=$nomClient;
    }

    public function getPrixBuffalo()
    {
        return $this->prixBuffalo;
    }

    public function setPrixBuffalo($prixBuffalo)
    {
        $this->prixBuffalo=$prixBuffalo;
    }

    public function getPrixAmericain()
    {
        return $this->prixAmericain;
    }

    public function setPrixAmericain($prixAmerican)
    {
        $this->prixAmericain=$prixAmericain;
    }
}

?>