<?php
class Commande {
    // attributs
    private $prixAmericain;
    private $prixBuffalo;
    private $nomClient;
    private $listeKebabs=array("Americain"=>0,"Buffalo"=>0);

    // constructeur
    public function __construct($prixBuffalo,$prixAmericain,$nomClient)
    {
        $this->prixBuffalo = $prixBuffalo;
        $this->prixAmericain = $prixAmericain;
        $this->nomClient = $nomClient;
    }

    // ajout de kebab
	public function addKebab($nomKebab,$nombre) 
	{
        $this->listeKebabs[$nomKebab] += $nombre;
        echo '<div class="alert alert-success">
                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                    <strong>Ajout!</strong> Vous avez ajouté '.$nombre.' Kebab(s) '.$nomKebab.'.
                </div>';
	}
	
    // suppression de kebab
 	public function removeKebab($nomKebab,$nombre) 
	{
        $this->listeKebabs[$nomKebab] -= $nombre;
		if ($this->listeKebabs[$nomKebab]<0) $this->listeKebabs[$nomKebab]=0;
        echo '<div class="alert alert-danger">
                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                    <strong>Suppression!</strong> Vous avez enlevé '.$nombre.' Kebab(s) '.$nomKebab.'.
                </div>';
	}

    // calcul de prix: cette méthode est privée car elle est uniquement utilisée à l'intérieur de la classe
    private function calculerPrix() 
	{
        // méthode simple, on fait la somme pour chaque kebab
        $montant_Americain = $this->listeKebabs["Americain"] * $this->prixAmericain;
        $montant_Buffalo = $this->listeKebabs["Buffalo"] * $this->prixBuffalo;
        return $montant_Americain + $montant_Buffalo;
        
        // méthode générique, on crée une variable dynamique
        $montant=0;
        foreach ($this->listeKebabs as $key=>$val)
        {
        	$prix="prix".$key;
        	$montant+=$val*$this->$prix;
        }
        return $montant;
    }

    // affichage de la commande
    public function afficherCommande() 
	{
        echo '<div class="row"><div class="col-md-8 col-md-offset-2"><section class="panel panel-featured panel-featured-success">
                <header class="panel-heading">
                    <div class="panel-actions">
                        <a href="#" class="fa fa-caret-down"></a>
                        <a href="#" class="fa fa-times"></a>
                    </div>

                    <h2 class="panel-title">Commande '.$this->nomClient.'</h2>
                </header>
                <div class="panel-body">
                    <ul>
                        <li>'.$this->listeKebabs["Americain"].' Kebab(s) Americain</li>
                        <li>'.$this->listeKebabs["Buffalo"].' Kebab(s) Buffalo</li></ul>
                        <div class="alert alert-success">
                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                    <strong>Total de votre commande :</strong> '.$this->calculerPrix().' euros.
                </div>
                </div>
            </section></div></div>';
	}

    // getters et setters
    public function getNomClient()
    {
        return $this->nomClient;
    }

    public function setNomClient($nomClient)
    {
        $this->nomClient=$nomClient;
    }

    public function getPrixBuffalo()
    {
        return $this->prixBuffalo;
    }

    public function setPrixBuffalo($prixBuffalo)
    {
        $this->prixBuffalo=$prixBuffalo;
    }

    public function getPrixAmericain()
    {
        return $this->prixAmericain;
    }

    public function setPrixAmericain($prixAmerican)
    {
        $this->prixAmericain=$prixAmericain;
    }

    public function getNb($typeKebab)
    {
        return $this->listeKebabs[$typeKebab];
    }

    public function getListeKebabs()
    {
        return $this->listeKebabs;
    }
}

?>